/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    public static final ResourceLocation HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/full");
    public static final ResourceLocation HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/full_blinking");
    public static final ResourceLocation HALF_HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/half");
    public static final ResourceLocation HALF_HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/half_blinking");
    public static final ResourceLocation EMPTY_HEART = ResourceLocation.withDefaultNamespace((String)"hud/heart/container");
    public static final ResourceLocation EMPTY_HEART_BLINKING = ResourceLocation.withDefaultNamespace((String)"hud/heart/container_blinking");
    private final float health;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private HealthTrackInfo track;

    public HealthElement(float maxHealth, float health) {
        this.health = health;
        IPluginConfig config = IWailaConfig.get().plugin();
        if (maxHealth > (float)config.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = Mth.ceil((float)maxHealth);
                health = Mth.ceil((float)health);
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = Mth.ceil((float)(maxHealth *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = Mth.ceil((float)(maxHealth / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().width(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = JadeClient.tickHandler().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health));
        }
        if (this.track != null) {
            this.track.setHealth(this.health);
            this.track.update(Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks());
            lastHealth = this.track.getLastHealth() * 0.5f;
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = this.getX() + xOffset;
            int yPos = this.getY() + yOffset;
            helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, blink ? EMPTY_HEART_BLINKING : EMPTY_HEART, xPos, yPos, 9, 9);
            if (i <= Mth.floor((float)health)) {
                helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, HEART, xPos, yPos, 9, 9);
            }
            if ((float)i > health) {
                if (i <= Mth.floor((float)lastHealth)) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, HEART_BLINKING, xPos, yPos, 9, 9);
                } else if ((float)i > lastHealth && (float)i < lastHealth + 1.0f) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, HALF_HEART_BLINKING, xPos, yPos, 9, 9);
                }
                if ((float)i < health + 1.0f) {
                    helper.blitSprite(graphics, RenderPipelines.GUI_TEXTURED, HALF_HEART, xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, this.text, (float)(this.getX() + 10), (float)(this.getY() + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public Component getNarration() {
        return Component.translatable((String)"narration.jade.health", (Object[])new Object[]{Mth.ceil((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

